﻿<?LassoScript

content_type:'text/xml; charset=UTF-8';
{
define_tag:'bail_misformed', -optional='msg';
	fail:-1, 'The POST data was not a valid SOAP request. ' local:'msg';
/define_tag;

define_type('paramFinder', -prototype);
	local('name'='');
	define_tag('onCreate', -req='name');
		self->'name' = #name;
	/define_tag;
	define_tag('onCompare'); 
		return(params->first->paramName == self->'name' ? 0 | 1);
	/define_tag;
/define_type;

protect;

local:'headers'=@client_headers;

if:#headers >> 'SOAPAction:';
	// pop out the operation name as signified by the SOAPAction header
	local:'operation' = (string_findregexp:#headers, -find='(?i)SOAPAction:\\s?([\\S]*)');
	if:#operation->size == 0;
		bail_misformed:'Couldn\'t find SOAPAction header field.';
	/if;
	#operation = #operation->get:2;
	#operation->removeLeading:'"';
	#operation->removeTrailing:'"';
	
	local:'theTag' = @($__SOAP__->find:#operation);

	if:#theTag == null;
		fail:-1, 'The SOAP operation ' #operation ' was not found.';
	/if;
	
	local:'args' = xml:client_postargs;
//	global:'ARGS'=@#args;

    // make a map of the namespaces
	local:'nsmap'=map;

    iterate:#args->extract("//*/namespace::*"), local:'curr'; /* */
        #nsmap->insert(
                #curr->extractOne('normalize-space()') = #curr->extractOne('name()'));
    /iterate;
	
	// SOAP-ENV ns prefix
	local:'SOAPENV' = #nsmap->find('http://schemas.xmlsoap.org/soap/envelope/');
	// LassoService ns prefix
	local:'LS' = #nsmap->find('http://www.omnipilot.com/services/LassoService.wsdl');
	// XSI ns prefix
	local:'XSI' = #nsmap->find('http://www.w3.org/1999/XMLSchema-instance');
	if:null == #XSI;
		#XSI = #nsmap->find('http://www.w3.org/2001/XMLSchema-instance');
	/if;
	// XSD ns prefix
	local:'XSD' = #nsmap->find('http://www.w3.org/1999/XMLSchema');
	if:null == #XSD;
		#XSD = #nsmap->find('http://www.w3.org/2001/XMLSchema');
	/if;
	// LassoTypes ns prefix
	local:'LPTYPES'=#nsmap->find('http://www.omnipilot.com/schemas/lp7types');
	
	// confirm its soapyness
	local:'env' = @#args->(extractOne:"/*[name()='" #SOAPENV ":Envelope']"); /* */
	if: !#env->isa:'xml';
		bail_misformed;
	/if;
	local:'body' = @#env->(extractOne:"*[name()='" #SOAPENV ":Body']");
	if: !#body->isa:'xml';
		bail_misformed:'Couldn\'t find SOAP Body element.';
	/if;
	
	local:'params'=#body->(extract:"*[local-name()='" #operation "' and namespace-uri()='http://www.omnipilot.com/services/LassoService.wsdl']/*"); /* */
	local:'paramsList' = array;

	local('expectedList' = #theTag->paramInfo);
	
	iterate:#params, local:'i';
		local('key' = (-a - 'a' + #i->name)); // trick to keep ->wasKeyword as true
		local('type' = #i->extractOne('normalize-space(attribute::*[name()=\'' #XSI ':type\'])'));
		if:#type->beginsWith(#XSD);
            #paramsList->insert(#key = xsd_deserialize(#i, #type->split(':')->last));
		else;
	   		// type was not explicit
	   		// we know what type the tag is expecting though
	   		local('theInfo' = #theTag->paramInfo->find(paramFinder(#i->name)));
	   		if (#theInfo->size);
	   			local('paramType' = #theInfo->first->paramType);
	   			local_reset('converter' = tags_find(#paramType));
	   			if (#converter != null);
	   				// complex types are not handled by the code below
	   				if (#paramType == 'array');
	   					local_reset('ary' = array);
	   					local_reset('elements' = #i->extract('*[local-name()=\'element\']/*[1]'));
	   					iterate(#elements, local('curr'));
	   						#ary->insert(null);
	   						#ary->last->deserialize(#curr);
	   					/iterate;
	   					#paramsList->insert(#key = @#ary);
	   				else;
		   				#paramsList->insert(#key = #converter->invoke(#i->contents));
		   			/if;
	   				loop_continue;
	   			/if;
	   		/if;
			#paramsList->insert(#key = null);
			#paramsList->last->second->deserialize:#i;			
		/if;
	/iterate;
	
	local:'res' = @#theTag->(run:-params=@#paramsList, -name=#operation);

	local:'ser'=#res->serialize:true;
	
	local:'resultMessage' = 
'<SOAP-ENV:Envelope 
	xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" 
	xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema"
	xmlns:lp7tns="http://www.omnipilot.com/schemas/lp7types">
	<SOAP-ENV:Body
		SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
		<m:' #operation 'Response xmlns:m="http://www.omnipilot.com/services/LassoService.wsdl">
			<m:return xsi:type="lp7tns:' (xsd_getSchemaType:#res->type) '" xmlns="http://www.omnipilot.com/schemas/lp7types">' #ser '</m:return>
		</m:' #operation 'Response>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>';
	
	
	$__html_reply__ = #resultMessage;	
else;
	fail:-1, 'Request did not contain the SOAPAction header';
/if;

handle_error;
	// fault
	log_detail:'FAILING in soap_handler.lasso';
	
	local:'faultMessage' = 
'<SOAP-ENV:Envelope 
	xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" 
	xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema">
	<SOAP-ENV:Body>
		<SOAP-ENV:Fault>
			<faultcode>Client</faultcode>
			<faultstring>' encode_xml(error_msg) '</faultstring>
		</SOAP-ENV:Fault>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>';
	
	$__html_reply__ = #faultMessage;
/handle_error;
/protect;
}->run;
?>